/* <nags.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library s Chapter
 *
 * Mark 4, revised, 1996.
 * Mark 5 revised. IER-2167 (Feb 1998).
 * Mark 6 revised. IER-3055 (July 2000).
 */
 

 
#ifndef NAGS
#define NAGS

/// ML 9/22/2004 COMPILING_ONAG8HEADERS_IN_OC
#ifndef _MSC_VER	   //VC
	// This must be put into every header since it does not appear to be
	// inheritable from parent header to child (#include-ded) header:
	#pragma dll(ONAG8)
#endif // !_MSC_VER	   //VC
/// end COMPILING_ONAG8HEADERS_IN_OC



#ifdef __cplusplus
extern "C"
{
#endif
  /* begin proto */
  //Cheney change Complex to complex 2006-6-6
  extern NAG_DLL_EXPIMP double NAG_CALL s01bac(double x, NagError *fail);
  extern double s01baf_f(double x, Integer *ifail);
  extern void s01eaf_f(complex *ret_val, complex &z, Integer *ifail);
  extern NAG_DLL_EXPIMP double NAG_CALL s07aac(double x, NagError *fail);
  extern double s07aaf_f(double x, Integer *ifail);
  extern NAG_DLL_EXPIMP double NAG_CALL s10aac(double x);
  extern NAG_DLL_EXPIMP double NAG_CALL s10abc(double x, NagError *fail);
  extern NAG_DLL_EXPIMP double NAG_CALL s10acc(double x, NagError *fail);
  extern NAG_DLL_EXPIMP double NAG_CALL s11aac(double x, NagError *fail);
  extern NAG_DLL_EXPIMP double NAG_CALL s11abc(double x);
  extern NAG_DLL_EXPIMP double NAG_CALL s11acc(double x, NagError *fail);
  extern NAG_DLL_EXPIMP double NAG_CALL s13aac(double x, NagError *fail);
  extern NAG_DLL_EXPIMP double NAG_CALL s13acc(double x, NagError *fail);
  extern NAG_DLL_EXPIMP double NAG_CALL s13adc(double x);
  extern NAG_DLL_EXPIMP double NAG_CALL s14aac(double x, NagError *fail);
  extern double s14aaf_f(double x, Integer *ifail);
  extern NAG_DLL_EXPIMP double NAG_CALL s14abc(double x, NagError *fail);
  extern double s14abf_f(double x, Integer *ifail);
  extern void s14acz_f (double x, Integer n, Integer kode, Integer m,
			double ans[], Integer * ier);
  extern void s14adf_f (double x, Integer n, Integer m, double w[], Integer * ifail);

  extern NAG_DLL_EXPIMP double NAG_CALL s14acc(double x, NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL s14adc(double x, Integer n, Integer m, double ans[], NagError *fail); 

  extern NAG_DLL_EXPIMP double NAG_CALL s14aec(double x, Integer k, NagError *fail);
  extern double s14aef_f(double x, Integer k, Integer *ifail);

  extern NAG_DLL_EXPIMP complex NAG_CALL s14afc(complex z__, Integer k, NagError *fail);
  extern NAG_DLL_EXPIMP complex NAG_CALL s14agc(complex &z, NagError *fail);
  extern void s14aff_f(complex *ret_val, complex &z, Integer k, Integer *ifail);
  extern NAG_DLL_EXPIMP void NAG_CALL s14bac(double a, double x, double tol, double *p, double *q, 
                                             NagError *fail);
  extern void s14baf_f(double a, double x, double tol, double *p,
                       double *q, Integer *ifail);
  extern double s14bax(double x);
  extern double s14bax_f(double x);
  extern double s14bay_f(double eta, double a, double eps);
  extern double s14bay(double eta, double a, double eps);
  extern double s14baz_f(double a, double x, Boolean getp, double eps,
                         double undfl);
  extern double s14baz(double a, double x, Boolean getp, double eps, double undfl);
  extern NAG_DLL_EXPIMP double NAG_CALL s15abc(double x);
  extern double s15abf_f(double x, Integer *ifail);
  extern NAG_DLL_EXPIMP double NAG_CALL s15acc(double x);
  extern double s15acf_f(double x, Integer *ifail);
  extern NAG_DLL_EXPIMP double NAG_CALL s15adc(double x);
  extern double s15adf_f(double x, Integer *ifail);
  extern NAG_DLL_EXPIMP double NAG_CALL s15aec(double x);
  extern double s15aef_f(double x, Integer *ifail);
  extern NAG_DLL_EXPIMP double NAG_CALL s15afc(double x); 
  extern NAG_DLL_EXPIMP complex NAG_CALL s15ddc(complex &z, NagError *fail);
  extern NAG_DLL_EXPIMP double NAG_CALL s17acc(double x, NagError *fail);
  extern NAG_DLL_EXPIMP double NAG_CALL s17adc(double x, NagError *fail);
  extern NAG_DLL_EXPIMP double NAG_CALL s17aec(double x, NagError *fail);
  extern NAG_DLL_EXPIMP double NAG_CALL s17afc(double x, NagError *fail);
  extern NAG_DLL_EXPIMP double NAG_CALL s17agc(double x, NagError *fail);
  extern NAG_DLL_EXPIMP double NAG_CALL s17ahc(double x, NagError *fail);
  extern NAG_DLL_EXPIMP double NAG_CALL s17ajc(double x, NagError *fail);
  extern NAG_DLL_EXPIMP double NAG_CALL s17akc(double x, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL s17alc (double a, Integer n, Integer mode, double rel,
                       double x[], NagError *fail);
  extern void s17alf_f(double a, Integer n, Integer mode, double rel, double x[], Integer *ifail);
  extern NAG_DLL_EXPIMP void NAG_CALL s17dcf_f(double fnu, complex &z, Integer n, const char *scale,
		       complex cy[], Integer *nz, complex cwrk[], Integer *ifail,
		       Integer scale_len);
  extern NAG_DLL_EXPIMP void NAG_CALL s17def_f(double fnu, complex &z, Integer n, const char *scale,
		       complex cy[], Integer *nz, Integer *ifail, Integer scale_len);
  extern void s17der_f(complex &z, double fnu, Integer n, complex cy[],
		       double tol);
  extern void s17des_f(complex &zr, double fnu, Integer kode, Integer n,
		       complex y[], Integer *nz, complex cw[], double tol,
		       double elim, double alim);
  extern void s17det_f(complex &z, double fnu, Integer kode, Integer n,
		      complex y[], Integer *nz, Integer *nlast, double fnul,
		      double tol, double elim, double alim);
  extern void s17deu_f(complex &z, double fnu, Integer ipmtr, double tol,
		      complex *phi, complex *arg, complex *zeta1, complex *zeta2,
		      complex *asum, complex *bsum, double elim);
  extern void s17dev_f(complex &z, double fnu, Integer kode, Integer ikflg,
		      Integer n, complex y[], Integer *nuf, double tol,
		      double elim, double alim);
  extern void s17dew_f(complex &zr, double fnu, Integer ikflg, Integer ipmtr,
		      double tol, Integer *init, complex *phi, complex *zeta1,
		      complex *zeta2, complex *sum, complex cwrk[], double elim);
  extern void s17dex_f(complex &z, double fnu, Integer kode, Integer n,
		      complex y[], Integer *nz, Integer *nlast, double fnul,
		      double tol, double elim, double alim);
  extern void s17dey_f(complex &z, double fnu, Integer kode, Integer n,
		      complex y[], Integer *nz, Integer nui, Integer *nlast,
		      double fnul, double tol, double elim, double alim);
  extern void s17dez_f(complex &z, double fnu, Integer kode, Integer n,
		       complex cy[], Integer *nz, double rl, double fnul,
		       double tol, double elim, double alim);
  extern void s17dgf_f(const char *deriv, complex &z, const char *scale, complex *ai,
		       Integer *nz, Integer *ifail, Integer deriv_len, Integer scale_len);
  extern void s17dgr_f(complex &z, double fnu, Integer kode, Integer n,
		      complex y[], Integer *nz, double tol, double elim,
		      double alim);
  extern void s17dgs_f(complex &zr, complex *s1, complex *s2, Integer *nz,
		       double ascle, double alim, Integer *iuf);
  extern void s17dgt_f(complex &z, double fnu, Integer kode, Integer n,
		      complex y[], Integer *nz, double tol);
  extern void s17dgu_f(complex &z, complex *csh, complex *cch);
  extern void s17dgv_f(complex &y, Integer *nz, double ascle, double tol);
  extern void s17dgw_f(complex &zr, double fnu, Integer n, complex y[],
		      Integer *nz, complex &rz, double ascle, double tol,
		      double elim);
  extern void s17dgx_f(complex &z, double fnu, Integer kode, Integer n,
		      complex y[], Integer *nz, double tol, double elim,
		      double alim);
  extern void s17dgy_f(complex &z, double fnu, Integer kode, Integer n,
		      complex y[], Integer *nz, double rl, double tol,
		      double elim, double alim);
  extern void s17dgz_f(complex &z, double fnu, Integer kode, Integer mr,
		      Integer n, complex y[], Integer *nz, double rl,
		      double tol, double elim, double alim);
  extern void s17dlf_f(Integer m, double fnu, complex &z, Integer n,
		      const char *scale, complex cy[], Integer *nz, Integer *ifail,
		      Integer scale_len);
  extern void s17dly_f(complex &z, double fnu, Integer kode, Integer mr,
		      Integer n, complex y[], Integer *nz, double tol,
		      double elim, double alim);
  extern void s17dlz_f(complex &z, double fnu, Integer kode, Integer mr,
		      Integer n, complex y[], Integer *nz, double rl,
		      double fnul, double tol, double elim, double alim);

  extern NAG_DLL_EXPIMP void NAG_CALL s17dcc(double fnu, complex &z, Integer n, Nag_ScaleResType scal, complex cy[], Integer *nz, NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL s17dec(double fnu, complex &z, Integer n, Nag_ScaleResType scal, complex cy[], Integer *nz, NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL s17dgc(Nag_FunType deriv, complex &z, Nag_ScaleResType scal, complex *ai, Integer *nz, NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL s17dhc(Nag_FunType deriv, complex &z, Nag_ScaleResType scal, complex *bi, NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL s17dlc(Integer m, double fnu, complex &z, Integer n, Nag_ScaleResType scal, complex cy[], Integer *nz, NagError *fail); 

  extern NAG_DLL_EXPIMP double NAG_CALL s18acc(double x, NagError *fail);
  extern NAG_DLL_EXPIMP double NAG_CALL s18adc(double x, NagError *fail);
  extern NAG_DLL_EXPIMP double NAG_CALL s18aec(double x, NagError *fail);
  extern NAG_DLL_EXPIMP double NAG_CALL s18afc(double x, NagError *fail);
  extern NAG_DLL_EXPIMP double NAG_CALL s18ccc(double x, NagError *fail);
  extern NAG_DLL_EXPIMP double NAG_CALL s18cdc(double x, NagError *fail);
  extern NAG_DLL_EXPIMP double NAG_CALL s18cec(double x);
  extern NAG_DLL_EXPIMP double NAG_CALL s18cfc(double x);

  extern NAG_DLL_EXPIMP void NAG_CALL s18dcc(double fnu, complex &z, Integer n, Nag_ScaleResType scal, complex cy[], Integer *nz, NagError *fail);
  extern void s18dcf_f(double fnu, complex &z, Integer n, const char *scale,
		       complex cy[], Integer *nz, Integer *ifail, Integer scale_len);
  extern void s18dcy_f(complex &z, double fnu, Integer kode, Integer mr,
		       Integer n, complex y[], Integer *nz, double tol,
		       double elim, double alim);
  extern void s18dcz_f(complex &z, double fnu, Integer kode, Integer mr,
		       Integer n, complex y[], Integer *nz, double tol,
		       double elim, double alim);


extern  NAG_DLL_EXPIMP
void NAG_CALL s18dec(double fnu, complex &z, Integer n, Nag_ScaleResType scal, complex cy[], Integer *nz, NagError *fail);

  extern void s18def_f(double fnu, complex &z, Integer n, const char *scale,
		       complex cy[], Integer *nz, Integer *ifail, Integer scale_len);

extern  NAG_DLL_EXPIMP
 double NAG_CALL s18ecc (double x, Integer nu, NagError *fail);
  extern double s18ecf_f (double x, Integer nu, Integer * ifail);

extern  NAG_DLL_EXPIMP
 double NAG_CALL s18edc (double x, Integer nu, NagError *fail);
  extern double s18edf_f (double x, Integer nu, Integer * ifail);

extern NAG_DLL_EXPIMP
 double NAG_CALL s18eec (double x, Integer nu, NagError *fail);
  extern double s18eef_f (double x, Integer nu, Integer * ifail);

extern NAG_DLL_EXPIMP
 double NAG_CALL s18efc (double x, Integer nu, NagError *fail);
  extern double s18eff_f (double x, Integer nu, Integer * ifail);

extern NAG_DLL_EXPIMP
 void NAG_CALL s18egc (double x, Integer ia, Integer ja, Integer nl,
	               double * b, NagError *fail);
  extern void s18egf_f (double x, Integer ia, Integer ja, Integer nl,
			double * b, Integer * ifail);

extern NAG_DLL_EXPIMP
 void NAG_CALL s18ehc (double x, Integer ia, Integer ja, Integer nl,
	               double * b, NagError *fail);
  extern void s18ehf_f (double x, Integer ia, Integer ja, Integer nl,
			double * b, Integer * ifail);

extern NAG_DLL_EXPIMP
 void NAG_CALL s18ejc (double x, double a, Integer nl, complex b[],
	               NagError *fail);
  extern void s18ejf_f (double x, double a, Integer nl, complex b[],
		      Integer * ifail);

extern NAG_DLL_EXPIMP
 void NAG_CALL s18ekc (double x, double a, Integer nl, complex b[],
	               NagError *fail);
  extern void s18ekf_f (double x, double a, Integer nl, complex b[],
			Integer * ifail);

  extern void s18elf_f (double x, double a, Integer nl, complex b[], Integer * ifail);
  extern void s18emf_f (double x, double a, Integer nl, complex b[], Integer * ifail);
  extern void s18enf_f(double x, double a, Integer nl, complex h1[],
		      complex h2[], Integer *ifail);
  extern void s18epf_f(double x, double a, Integer nl, complex b[],
		      Integer *ifail);
  extern void s18eqf_f(double x, double a, Integer nl, complex b[],
		      Integer *ifail);
  extern void s18erf_f(double x, double a, Integer nl, complex b[],
		      Integer *ifail);
  extern void s18esf_f(double x, double a, Integer nl, complex b[],
		      Integer *ifail);
  extern void s18etf_f(double x, double a, Integer nl, complex h1[],
		      complex h2[], Integer *ifail);
  extern void s18fjf_f(double x, double a, Integer nl, complex b[],
		      Integer *ifail);
  extern void s18fkf_f(double x, double a, Integer nl, complex b[],
		      Integer *ifail);
  extern void s18flf_f(double x, double a, Integer nl, complex b[],
		      Integer *ifail);
  extern void s18fmf_f(double x, double a, Integer nl, complex b[],
		      Integer *ifail);
  extern void s18fnf_f(double x, double a, Integer nl, complex h1[],
		      complex h2[], Integer *ifail);
  extern void s18fpf_f(double x, double a, Integer nl, complex b[],
		      Integer *ifail);
  extern void s18fqf_f(double x, double a, Integer nl, complex b[],
		      Integer *ifail);
  extern void s18frf_f(double x, double a, Integer nl, complex b[],
		      Integer *ifail);
  extern void s18fsf_f(double x, double a, Integer nl, complex b[],
		      Integer *ifail);
  extern void s18ftf_f(double x, double a, Integer nl, complex h1[],
		      complex h2[], Integer *ifail);
  extern void s18gjf_f(complex &z, double a, Integer nl, complex b[],
		      Integer *ifail);
  extern NAG_DLL_EXPIMP void NAG_CALL s18gkc(complex &z, double a, Integer nl, complex b[], NagError *fail); 
  extern void s18gkf_f(complex &z, double a, Integer nl, complex b[],
		      Integer *ifail);
  extern void s18glf_f(complex &z, double a, Integer nl, complex b[],
		      Integer *ifail);
  extern void s18gmf_f(complex &z, double a, Integer nl, complex b[],
		      Integer *ifail);
  extern void s18gnf_f(complex &z, double a, Integer nl, complex h1[],
		      complex h2[], Integer *ifail);
  extern void s18gpf_f(complex &z, double a, Integer nl, complex b[],
		      Integer *ifail);
  extern void s18gqf_f(complex &z, double a, Integer nl, complex b[],
		      Integer *ifail);
  extern void s18grf_f(complex &z, double a, Integer nl, complex b[],
		      Integer *ifail);
  extern void s18gsf_f(complex &z, double a, Integer nl, complex b[],
		      Integer *ifail);
  extern void s18gtf_f(complex &z, double a, Integer nl, complex h1[],
		      complex h2[], Integer *ifail);
  extern void s18hjf_f(complex &z, double a, Integer nl, complex b[],
		      Integer *ifail);
  extern void s18hkf_f(complex &z, double a, Integer nl, complex b[],
		      Integer *ifail);
  extern void s18hlf_f(complex &z, double a, Integer nl, complex b[],
		      Integer *ifail);
  extern void s18hmf_f(complex &z, double a, Integer nl, complex b[],
		      Integer *ifail);
  extern void s18hnf_f(complex &z, double a, Integer nl, complex h1[],
		      complex h2[], Integer *ifail);
  extern void s18hpf_f(complex &z, double a, Integer nl, complex b[],
		      Integer *ifail);
  extern void s18hqf_f(complex &z, double a, Integer nl, complex b[],
		      Integer *ifail);
  extern void s18hrf_f(complex &z, double a, Integer nl, complex b[],
		      Integer *ifail);
  extern void s18hsf_f(complex &z, double a, Integer nl, complex b[],
		      Integer *ifail);
  extern void s18htf_f(complex &z, double a, Integer nl, complex h1[],
		      complex h2[], Integer *ifail);
  extern NAG_DLL_EXPIMP double NAG_CALL s19aac(double x, NagError *fail);
  extern NAG_DLL_EXPIMP double NAG_CALL s19abc(double x, NagError *fail);
  extern NAG_DLL_EXPIMP double NAG_CALL s19acc(double x, NagError *fail);
  extern NAG_DLL_EXPIMP double NAG_CALL s19adc(double x, NagError *fail);
  extern NAG_DLL_EXPIMP double NAG_CALL s20acc(double x);
  extern NAG_DLL_EXPIMP double NAG_CALL s20adc(double x);
  extern NAG_DLL_EXPIMP double NAG_CALL s21bac(double x, double y, NagError *fail);
  extern double s21baf_f(double x, double y, Integer *ifail);
  extern NAG_DLL_EXPIMP double NAG_CALL s21bbc(double x, double y, double z, NagError *fail);
  extern NAG_DLL_EXPIMP double NAG_CALL s21bcc(double x, double y, double z, NagError *fail);
  extern NAG_DLL_EXPIMP double NAG_CALL s21bdc(double x, double y, double z, double r, NagError *fail);
  extern void s21caf_f(double u, double m, double *sn, double *cn,
		      double *dn, Integer *ifail);
  extern void s21caf_f (double u, double m, double * sn, double * cn,
			double * dn, Integer * ifail);

extern NAG_DLL_EXPIMP
 void NAG_CALL s21cbc (complex &z, double ak2, complex * sn, complex * cn,
	               complex * dn, NagError *fail);
  extern void s21cbf_f (complex &z, double ak2, complex * sn, complex * cn,
			complex * dn, Integer * ifail);

extern NAG_DLL_EXPIMP
 double NAG_CALL s21ccc (Integer k, double x, double q, NagError *fail);
  extern double s21ccf_f(Integer k, double x, double q, Integer *ifail);

extern NAG_DLL_EXPIMP
  complex NAG_CALL s21dac (complex &z, double akp, double a,
	               double b, NagError *fail);

  extern /* Double complex */ void
  s21daf_f (complex * ret_val, complex &z, double akp, double a,
         double b, Integer * ifail);

  extern NAG_DLL_EXPIMP void NAG_CALL s22aac (Integer mode, double x, Integer m, Integer nl,double * p, NagError *fail);

  extern /*  Subroutine */ void
  s22aaf_f (Integer mode, double x, Integer m, Integer nl,
	 double * p, Integer * ifail);

  extern NAG_DLL_EXPIMP void NAG_CALL s21cac(double u, double m, double *sn, double *cn, double *dn, NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL s23aac(complex &z, complex &eta, complex &zlmin, Integer nl, Integer kfn, Integer mode, complex f[], complex g[], complex fp[], complex gp[], complex sig[], NagError *fail); 
  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGS */
